<?php

/**
 * This is the model class for table "Faktury".
 *
 * The followings are the available columns in table 'Faktury':
 * @property double $id
 * @property double $idFirmy
 * @property double $idKontrahenta
 * @property string $opis
 * @property string $dataWystawienia
 * @property string $dataPlatnosci
 * @property string $nrFaktury
 * @property double $cenaNetto
 * @property double $stawkaVat
 * @property string $czyKoszt
 *
 * @property string $cenaBrutto
 * @property string $cenaNettoCurrency
 * @property string $cenaBruttoCurrency
 * @property string $stawkaVatProc
 * @property string $kwotaVat
 * @property string $kwotaVatCurrency
 * @property string $cenaBruttoWord
 * @property string $dataWystawieniaYmd
 * @property string $dataPlatnosciYmd
 *
 * @property Firma      $firma
 * @property Kontrahent $kontrahent
 */
class Faktury extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Faktury the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'Faktury';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idFirmy, idKontrahenta', 'required'),
			array('idFirmy, idKontrahenta, cenaNetto, stawkaVat', 'numerical'),
			array('opis', 'length', 'max'=>512),
			array('nrFaktury', 'length', 'max'=>32),
			array('czyKoszt', 'length', 'max'=>1),
			array('dataWystawienia, dataPlatnosci', 'safe'),

			array('id, idFirmy, idKontrahenta, opis, dataWystawienia, dataPlatnosci, nrFaktury, cenaNetto, stawkaVat, czyKoszt', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'firma'=>array(self::BELONGS_TO, 'Firma', 'idFirmy'),
			'kontrahent'=>array(self::BELONGS_TO, 'Kontrahent', 'idKontrahenta'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('Faktury', 'id'),
			'idFirmy'=>Yii::t('Faktury', 'idFirmy'),
			'idKontrahenta'=>Yii::t('Faktury', 'idKontrahenta'),
			'opis'=>Yii::t('Faktury', 'opis'),
			'dataWystawienia'=>Yii::t('Faktury', 'dataWystawienia'),
			'dataPlatnosci'=>Yii::t('Faktury', 'dataPlatnosci'),
			'nrFaktury'=>Yii::t('Faktury', 'nrFaktury'),
			'cenaNetto'=>Yii::t('Faktury', 'cenaNetto'),
			'stawkaVat'=>Yii::t('Faktury', 'stawkaVat'),
			'czyKoszt'=>Yii::t('Faktury', 'czyKoszt'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('idFirmy', $this->idFirmy);
		$criteria->compare('idKontrahenta', $this->idKontrahenta);
		$criteria->compare('opis', $this->opis, true);
		$criteria->compare('dataWystawienia', $this->dataWystawienia, true);
		$criteria->compare('dataPlatnosci', $this->dataPlatnosci, true);
		$criteria->compare('nrFaktury', $this->nrFaktury, true);
		$criteria->compare('cenaNetto', $this->cenaNetto);
		$criteria->compare('stawkaVat', $this->stawkaVat);
		$criteria->compare('czyKoszt', $this->czyKoszt, true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	public function getCenaBrutto()
	{
		return $this->cenaNetto * (1 + $this->stawkaVat);
	}

	public function getCenaNettoCurrency($currency = 'PLN')
	{
		return number_format($this->cenaNetto, 2, ',', ' ') . ' ' . $currency;
	}

	public function getCenaBruttoCurrency($currency = 'PLN')
	{
		return number_format($this->cenaBrutto, 2, ',', ' ') . ' ' . $currency;
	}

	public function getStawkaVatProc()
	{
		return number_format($this->stawkaVat*100, 0, ',', ' ') . '%';
	}

	public function getKwotaVat()
	{
		return $this->cenaNetto * $this->stawkaVat;
	}

	public function getKwotaVatCurrency($currency = 'PLN')
	{
		return number_format($this->kwotaVat, 2, ',', ' ') . ' ' . $currency;
	}

	public function getCenaBruttoWord()
	{
		$result = StringUtils::numberToWorld($this->cenaBrutto) . ' '
			. StringUtils::numberUnitWorld($this->cenaBrutto,
				array('złoty', 'złote', 'złotych'));
		$grosze = (int)(round($this->cenaBrutto * 100)) % 100;
		return trim($result) . ' ' . $grosze . '/100';
	}

	public function getDataWystawieniaYmd()
	{
		return empty($this->dataWystawienia) ? '' : date('Y/m/d', strtotime($this->dataWystawienia));
	}

	public function getDataPlatnosciYmd()
	{
		return empty($this->dataPlatnosci) ? '' : date('Y/m/d', strtotime($this->dataPlatnosci));
	}
}